# coding:utf-8

require 'tmpdir'
require 'uri'
require 'net/http'
require 'fileutils'
require 'zip'
require 'push_exchanger'
require 'monpe'
require 'pp'
require 'stringio'
require_relative '../lib/orca-string'
require_relative '../lib/orca-wareki'

class Okusuri_la02hc62

  require_relative './la02hc62Conf.rb'
  COL_SIZE = 25
  COL_SIZE_FULL = 27
  ROW_SIZE = 68

  if  PWIDTH  == 1
    RED_FILE = 'LA02HCM62312.red'
  else
    RED_FILE = 'LA02HCM62412.red'
  end

  RED_FILE_QR = 'HCM62Q.red'
  QR_MAX = 12

  def to_num(v)
    ((float = Float(v)) && (float % 1.0 == 0) ? float.to_i : float) rescue v
  end

  def edit_lines(name, amount)
    lines = name.scan(/.{1,#{COL_SIZE}}/)
    if lines.size == 0 or (lines.last + amount).size >= COL_SIZE
      lines.push(('　' * (COL_SIZE - amount.size) + amount))
    else
      if amount != ''
        lines[-1] = lines.last + '　' * (COL_SIZE - (lines.last + amount).size) + amount
      end
    end

    return lines
  end

  def edit_draft

    hospital = @data['Hospital'] || {}
    start_lines = Array.new

    Array(@data['Rp']).each do |rp|
      next if rp['Medical_Class'].nil?

      start_lines.push(@draft.size)
      rp['Medication'].each do |m|
        if !m['Name'].nil?
          amount = to_num(m['Amount']).to_s.zenkaku + m['Unit_Name'].to_s
          @draft.concat(edit_lines(m['Name'], amount))
        end
      end
      if ['21','22'].include?(rp['Medical_Class']) and rp['Not_Countable_Flg'] != '1'
        count = to_num("#{rp['Amount']}#{rp['Count']}").to_s.zenkaku + rp['Unit_Name'].to_s
        @draft.concat(edit_lines(@draft.pop, count))
      end
      @under_lines.push(@draft.size - 1)
#puts @data
    end

    unless Array(@data['Memo']).empty?
      @data['Memo'].each do |memo|
        next if memo.to_s.strip.empty?
        @draft.concat(edit_lines(memo,''))
      end
      @under_lines.push(@draft.size - 1)
    end

    @draft.map!.with_index do |v, i|
      index = start_lines.index(i)
      index.nil? ? "  　#{v}" : "#{'%2d' % (index + 1) }）#{v}"
    end

    if PIRYONAME == 1
      @draft.push(Array(hospital['Name'])[0].to_s[0, 27])
      @draft.push(hospital['PhoneNumber'])
    end
  end

  def edit_under_line(embed_data, col_index)
    embed_data["SEN[#{col_index}]"] = "_" * COL_SIZE_FULL * 2
  end

  def edit_form_top(embed_data, col_index)

    @pageno += 1
    patinent = @data['Patient']  || {}
    doctor = @data['Doctor'] || {}

    if patinent['Name'].to_s.size > 22
#      embed_data["NAIYO1[#{col_index}]"] ="#{patinent['Name'].to_s[0,22].ljust(22,"　")}#{@pageno.to_s.rjust(8 ," ")}頁"
      embed_data["NAIYO1[#{col_index}]"] ="#{patinent['Name'].to_s[0,22].ljust(22,"　")}"
      col_index += 1
      embed_data["NAIYO1[#{col_index}]"] ="#{patinent['Name'].to_s[22,5]}　様"
      col_index += 1
    else
#      embed_data["NAIYO1[#{col_index}]"] ="#{(patinent['Name'].to_s[0,22] + "　様").ljust(24,"　")}#{@pageno.to_s.rjust(4, " ")}頁"
      embed_data["NAIYO1[#{col_index}]"] ="#{(patinent['Name'].to_s[0,22] + "　様").ljust(24,"　")}"
      col_index += 1
    end

    perform_date = '　　  年  月  日'
    unless @data['Perform_Date'].to_s.strip.empty?
      ymd =Orca::Wareki.new(@data['Perform_Date'])
      perform_date = '%s%2d年%2d月%2d日' % [ymd.gengoN, ymd.year_w, ymd.month, ymd.day]
    end
    embed_data["NAIYO1[#{col_index}]"] = "処方日 #{perform_date} 保険医名 #{doctor['Name'].to_s[0,9]} "
    edit_under_line(embed_data, col_index)
    col_index += 1

    return col_index

  end


  def get_qr

    qr = Array.new

    return qr if @data['Qr_ID'].nil?
    begin
      path = "/api01rv2/imagegetv2"
      xml = <<-EOF
        <data>
          <imagegetv2req type="record">
            <Image_ID type="string">#{@data['Qr_ID']}</Image_ID>
          </imagegetv2req>
        </data>
      EOF
      res = PushExchanger::Util::http_post(@opt[:conf],"/api01rv2/imagegetv2",xml,"application/xml")
      unless res.code == "200"
        raise "http error:#{path} #{res.code}"
      end

      io = ::StringIO.new(res.body)
      Zip::File.open_buffer(io) do |zf|
        zf.sort.each do |entry|
          extracted_file = "#{@temp_dir}/#{entry.name}"
          entry.extract(extracted_file){true}
          qr.push(extracted_file) if extracted_file =~ /png$/
        end
      end
    rescue => e
      p e
    ensure
      return qr
    end
  end

  def edit_form(offset_1, offset_q)

    forms = Array.new

    form_dir = File.dirname(File.expand_path(__FILE__))
    red_file = File.join(form_dir, RED_FILE)
    dummy_image = File.join(form_dir, 'transparent.png')
    form = Monpe::Report.new(red_file)
    embed_data = form.get_embed_data
    col_index = 0
    col_index = edit_form_top(embed_data, col_index)

    @draft.each_with_index do |row, i|
      if (col_index).modulo(ROW_SIZE) == 0
        form.set_embed_data(embed_data)
        forms.push(form)
        form = Monpe::Report.new(red_file)
        embed_data = form.get_embed_data
        col_index = 0
        col_index = edit_form_top(embed_data, col_index)
      end

#      if (col_index).modulo(ROW_SIZE / 2) == 0
#        col_index = edit_form_top(embed_data, col_index)
#      end

      embed_data["NAIYO1[#{col_index}]"] = row

      edit_under_line(embed_data, col_index) if @under_lines.include?(i)
      col_index += 1
    end

    form.set_embed_data(embed_data)
    form.set_offset(*offset_1) if offset_1
    forms.push(form)

    qr = get_qr
    unless qr.empty?
      red_file = File.join(form_dir, RED_FILE_QR)
      form = Monpe::Report.new(red_file)
      col_index = 0
      embed_data = form.get_embed_data
      edit_form_top(embed_data, col_index)
      QR_MAX.times do |i|
        embed_data["IMAGE-1[#{i}]"] = qr[i] || dummy_image
      end
      hospital = @data['Hospital'] || {}
      embed_data["NAIYO1[3]"] = Array(hospital['Name'])[0].to_s[0, 27]
      embed_data["NAIYO1[4]"] = hospital['PhoneNumber']
      edit_under_line(embed_data, 3)
      form.set_embed_data(embed_data)
      form.set_offset(*offset_q) if offset_q
      forms.push(form)
    end

    return forms

  end


  def export(pdf_file, form_data, opt)

    offset_set = opt[:pr_conf][:offset_settings]
    if offset_set
      offset_1 =  offset_set[RED_FILE.to_sym]
      offset_q =  offset_set[RED_FILE_QR.to_sym]
    else
      offset_1 = nil
      offset_q = nil
    end

    forms = Array.new
    @temp_dir = Dir.mktmpdir
    @opt = opt

    form_data['Forms'].each do |hash|
      @data = hash['data']
      @draft = Array.new
      @under_lines = Array.new
      @pageno = 0
      edit_draft
      forms.concat(edit_form(offset_1, offset_q))
    end

    Monpe.export(forms, pdf_file)
    FileUtils.remove_entry_secure @temp_dir
  end
end

=begin
pdf_file = "okusuri_la02hc62.pdf"
form_data = <<EOF
{
  "Forms": [
    {
      "data": {
      }
    }
  ]
}
EOF

conf = { :api_user => 'ormaster',
         :api_key => 'ormaster',
         :api_server => 'localhost',
         :api_port => 8000 }
opt = Hash.new
opt[:conf] = conf
require 'json'
form = Okusuri_la02hc62.new
form.export(pdf_file, JSON.parse(form_data), opt)
=end
