# coding : utf-8

require 'monpe'
require 'pp'
require_relative '../lib/orca-string'
require_relative '../lib/orca-wareki'

class Karte_a405hc01

  require_relative './a405hc01Conf.rb'
  FIRST_PAGE_DISEASE_ROWS = 15
  MIDDLE_PAGE_DISEASE_ROWS = 28
  if B5FORMAT == 1
    RED_FILE = 'A405HCM013B5.red'
    RED_FILE2 = 'A405HCM011B5.red'
  else
    RED_FILE = 'A405HCM013.red'
    RED_FILE2 = 'A405HCM011.red'
  end

  def export(fname, form_data, opt)
    offset_set = opt[:pr_conf][:offset_settings]
    if offset_set
      offset_1 =  offset_set[RED_FILE.to_sym]
      offset_n =  offset_set[RED_FILE2.to_sym]
    else
      offset_1 = nil
      offset_n = nil
    end

    forms = []
    form_data['Forms'].each do |hash|
      @data = hash['data']
      if @data['Order_Class'] == '2'
        f = make_later_page
        f.set_offset(*offset_n) if offset_n
        forms << f
        next
      end

      ary = edit_ary
      f = make_1st_page(ary)
      f.set_offset(*offset_1) if offset_1
      forms << f
      start_row = FIRST_PAGE_DISEASE_ROWS
      while ary.size  > start_row
        f = make_later_page(ary, start_row)
        f.set_offset(*offset_n) if offset_n
        forms << f
        start_row += MIDDLE_PAGE_DISEASE_ROWS
      end
    end

    Monpe.export(forms,fname)
  end

  def edit_ary
    ary = Array.new

    Array(@data['Disease_Information']).delete_if(&:empty?).each do |hash|
      ary.push(hash) unless hash['Name'].to_s.empty?
    end

    return ary
  end

  def make_1st_page(ary)
    red = File.join(File.dirname(File.expand_path(__FILE__)),RED_FILE)
    form = Monpe::Report.new(red)
    embed_data = form.get_embed_data

    set_head(embed_data)

    unless ary.nil?
      FIRST_PAGE_DISEASE_ROWS.times do |i|
        disease = ary[i]
        next unless disease
        idx = i
        set_disease_row(embed_data,disease,idx)
      end
    end

    form.set_embed_data(embed_data)
    return form
  end

  def set_head(embed_data)

    patient = @data['Patient'] || {}

    if KARUTECM10 == 1
        embed_data['PTNUM2']    = patient['ID']
    else
        embed_data['PTNUM']    = patient['ID']
    end
    if patient['KanaName'].to_s.size > 15
      embed_data['KANANAME2'] = patient['KanaName'].to_s[0,30]
    else
      embed_data['KANANAME'] = patient['KanaName'].to_s[0,15]
    end
    if patient['Name'].to_s.size > 15
      embed_data['NAME2'] = patient['Name'].to_s[0,30]
    else
      embed_data['NAME'] = patient['Name'].to_s[0,15]
    end
    unless patient['BirthDate'].to_s.strip.empty?
      ymd = Orca::Wareki.new(patient['BirthDate'])
      embed_data['TANJYOG'] = ymd.gengoN
      embed_data['TANJYOY'] = '%2d' % ymd.year_w
      embed_data['TANJYOM'] = '%2d' % ymd.month
      embed_data['TANJYOD'] = '%2d' % ymd.day
      embed_data['NENREI'] = ymd.age
    end
    embed_data['OTOKO'] = '○' if patient['Sex'] == '1'
    embed_data['ONNA'] = '○' if patient['Sex'] == '2'

    home_address = patient['Home_Address'] || {}
    embed_data['ADRSTEL'] = home_address['PhoneNumber']
    embed_data['ADRSTEL2'] = home_address['ContactNumber']
    if home_address['ZipCode'].length >= 3
      embed_data['POST'] = '〒' + home_address['ZipCode'][0, 3]
    end  
    if home_address['ZipCode'].length >= 4 and home_address['ZipCode'].length <= 7
      embed_data['POST'] += '-' + home_address['ZipCode'][3, 4]
    end  

    h_address = home_address['Address'] || []
    embed_data['ADRS'] = "#{h_address[0]}#{h_address[1]}"[0, 32].zenkaku

    if DELADRS1.length > 0
      embed_data['ADRS'] = lstrip_fullwidth(embed_data['ADRS'], DELADRS1)
    end
    if DELADRS2.length > 0
      embed_data['ADRS'] = lstrip_fullwidth(embed_data['ADRS'], DELADRS2)
    end
#puts embed_data['ADRS']

    #備考欄
    j = 0;
    4.times do |i|
      sayu = KARUTECM1[i][2,1].to_i - 1
      title = KARUTECM1[i][4,1]
#puts 'i='+i.to_s
#puts 'komoku='+KARUTECM1[i][0,1]
#puts 'sayu='+sayu.to_s
#puts 'title='+title
      case KARUTECM1[i][0,1]
      when '1'
        if title == '1'
          embed_data["BIKO[#{j}]"] += '禁　　　忌：'
        end
        comm_Taboo = patient['Taboo'] || []
        embed_data["BIKO[#{j}]"] += comm_Taboo[sayu].to_s
        j += 1
      when '2'
        if title == '1'
          embed_data["BIKO[#{j}]"] += 'アレルギー：'
        end
        comm_Allergy = patient['Allergy'] || []
        embed_data["BIKO[#{j}]"] += comm_Allergy[sayu].to_s
        j += 1
      when '3'
        if title == '1'
          embed_data["BIKO[#{j}]"] += '感　染　症：'
        end
        comm_Infection = patient['Infection'] || []
        embed_data["BIKO[#{j}]"] += comm_Infection[sayu].to_s
        j += 1
      when '4'
        if title == '1'
          embed_data["BIKO[#{j}]"] += 'コメント　：'
        end
        comm_Comment = patient['Comment'] || []
        embed_data["BIKO[#{j}]"] += comm_Comment[sayu].to_s
        j += 1
      else
      end
    end

    #備考欄上
    j = 0;
    2.times do |i|
      sayu = COMMTOP[i][2,1].to_i - 1
#puts 'i='+i.to_s
#puts 'komoku='+COMMTOP[i][0,1]
#puts 'sayu='+sayu.to_s
      case COMMTOP[i][0,1]
      when '1'
        comm_Taboo = patient['Taboo'] || []
        embed_data["COMMTOP[#{j}]"] += comm_Taboo[sayu].to_s
        j += 1
      when '2'
        comm_Allergy = patient['Allergy'] || []
        embed_data["COMMTOP[#{j}]"] += comm_Allergy[sayu].to_s
        j += 1
      when '3'
        comm_Infection = patient['Infection'] || []
        embed_data["COMMTOP[#{j}]"] += comm_Infection[sayu].to_s
        j += 1
      when '4'
        comm_Comment = patient['Comment'] || []
        embed_data["COMMTOP[#{j}]"] += comm_Comment[sayu].to_s
        j += 1
      else
      end
    end

    insurance = @data['Insurance_Combination_Information'] || {}
    h_insurance = insurance['HealthInsurance_Information'] || {}
    a_insurance = insurance['Accident_Insurance_Information'] || {}

    hospital = @data['Hospital'] || {}

    if ! ['9999' , '' ].include?(h_insurance['Certificate_GetDate'].to_s[0,4].strip)
      ymd = Orca::Wareki.new(h_insurance['Certificate_GetDate'])
      embed_data['SIKAKUG'] = ymd.gengoN
      embed_data['SIKAKUY'] = '%2d' % ymd.year_w
      embed_data['SIKAKUM'] = '%2d' % ymd.month
      embed_data['SIKAKUD'] = '%2d' % ymd.day
    end

    symbol = h_insurance['HealthInsuredPerson_Symbol'].to_s
    number = h_insurance['HealthInsuredPerson_Number'].to_s
    symbol_number = "#{symbol}・#{number}"

    #本人家族
    case h_insurance['RelationToInsuredPerson'].to_s
    when '1'
      embed_data['HONKZK'] = '本人'
    when '2'
      embed_data['HONKZK'] = '家族'
    end

    case insurance['InsuranceProvider_Class']
    when '975'
      embed_data['HPTNUM'] = insurance['InsuranceProvider_Name'].to_s[0, 8].zenkaku
    when '971', '973'
      unless h_insurance['HealthInsuredPerson_Symbol'].to_s.empty? 
        hptnum = "#{h_insurance['HealthInsuredPerson_Symbol']}・#{h_insurance['HealthInsuredPerson_Number']}"
        embed_data['HPTNUM'] = hptnum.to_s[0, 8].zenkaku
      end
      symbol_number = a_insurance['Accident_Insurance_Number'].to_s.zenkaku
    else
      unless h_insurance['InsuranceProvider_Number'].to_s.empty? 
        embed_data['HPTNUM'] = h_insurance['InsuranceProvider_Number'].to_s.zenkaku.rjust(8,"　")
      end
    end

    unless "#{symbol}#{number}".empty?
      if insurance['InsuranceProvider_Class'] == '039'
        embed_data["KIGONUM"] =  number
      else
        if symbol_number.size > 14
          embed_data["KIGO"] = symbol[0, 14]
          embed_data["NUM"] = number[0, 14]
        else
          embed_data["KIGONUM"] = symbol_number
        end
      end
    end

    embed_data["EDABAN"] = h_insurance['HealthInsuredPerson_Branch_Number'].to_s.zenkaku

    embed_data['HIHKNJNAME'] = h_insurance['HealthInsuredPerson_Name'].to_s[0,11]
    embed_data['TUZUKI'] = patient['Relationship'].to_s[0,4]
    embed_data['WORK'] = patient['Job'].to_s[0,8]

    if ! ['9999' , '' ].include?(h_insurance['Certificate_ExpiredDate'].to_s[0,4].strip)
      ymd = Orca::Wareki.new(h_insurance['Certificate_ExpiredDate'])
      embed_data['YUKOG'] = ymd.gengoN
      embed_data['YUKOY'] = '%2d' % ymd.year_w
      embed_data['YUKOM'] = '%2d' % ymd.month
      embed_data['YUKOD'] = '%2d' % ymd.day
    end

    o_address = patient['Office_Address'] || {}
    embed_data['KINNAME'] = o_address['Name'].to_s[0,15]
    embed_data['KINADRS'] = [o_address['Address']].join.to_s[0,15]
    embed_data['KINADRSTEL'] = o_address['PhoneNumber']

    embed_data['HKNNAME'] = h_insurance['InsuranceProvider_Name'].to_s[0,15]
    embed_data['HKNADRS'] = [h_insurance['InsuranceProvider_Address']].join.to_s[0,15]
    embed_data['HKNADRSTEL'] = h_insurance['InsuranceProvider_PhoneNumber']

    #保険名称
    embed_data['HKNCOMBI'] = insurance['InsuranceProvider_Name']

    if insurance['PublicInsurance_Information']
      3.times do |i|
        unless insurance['PublicInsurance_Information'][i].nil? then
          p_insurance = insurance['PublicInsurance_Information'][i]
          p_num = p_insurance['PublicInsurer_Number'].to_s
          #保険名称+公費名称
          embed_data['HKNCOMBI'] += '　' + p_insurance['PublicInsurance_Name'].to_s
          pp_num = p_insurance['PublicInsuredPerson_Number'].to_s
          if p_insurance['PublicInsurance_Class'] == '970'
            p_num = p_insurance['PublicInsurance_Name'].to_s
            pp_num = "（#{pp_num}）"
          end

          #公費完了日
          if  KOHED == 1
            embed_data["KOHEDMOJI[#{i}]"] = '　　　　年　　月　　日'
            if (! ['9999' , '' ].include?(p_insurance['Certificate_ExpiredDate'].to_s[0,4].strip)) and KOHED == 1
              ymd = Orca::Wareki.new(p_insurance['Certificate_ExpiredDate'])
              embed_data["KOHEDG[#{i}]"] = ymd.gengoN
              embed_data["KOHYMD-TBL[#{i}].KOHED.KOHEDYMD[0]"] = ('%2d' % ymd.year_w).zenkaku
              embed_data["KOHYMD-TBL[#{i}].KOHED.KOHEDYMD[1]"] = ('%2d' % ymd.month).zenkaku
              embed_data["KOHYMD-TBL[#{i}].KOHED.KOHEDYMD[2]"] = ('%2d' % ymd.day).zenkaku
            end
          end

          embed_data["FKOH-TBL[#{i}].FTNSNO"] = p_num.to_s[0,8].zenkaku
          case pp_num.size
          when 0..7
            embed_data["JKOH-TBL[#{i}].JKYSNO"] = pp_num[0,7].zenkaku
          when 8..10
            embed_data["JKOHN-TBL[#{i}].JKYSNON"] = pp_num[0,10].zenkaku
          when 11..12
            embed_data["JKOH12-TBL[#{i}].JKYSNO12"] = pp_num[0,12].zenkaku
          else
            embed_data["JKOH15-TBL[#{i}].JKYSNO15"] = pp_num[0,15].zenkaku
          end
        end
      end
    end

    5.times { |i| embed_data["COMMENT[#{i}]"] = @data['Memo'][i] } if @data['Memo']

    #基準日（カルテ印刷の日付）
    if KIJUN == 1
      embed_data['KIJUN'] = '基準日：'
      ymd = Orca::Wareki.new(Date.today.to_s)
      embed_data['KIJUN'] += ymd.gengoN
      embed_data['KIJUN'] += ('%2d' % ymd.year_w).zenkaku + '年'
      embed_data['KIJUN'] += ('%2d' % ymd.month).zenkaku + '月'
      embed_data['KIJUN'] += ('%2d' % ymd.day).zenkaku + '日'
    end

    #医療機関名
    if IRYOMEISIZE == 1
        embed_data['IRYOMEI2'] = hospital['Name']
    else
        embed_data['IRYOMEI'] = hospital['Name']
    end
#puts @data
  end


  def set_disease_row(embed_data,disease,idx)
    embed_data["BYOMEI-TBL[#{idx}].BYOMEIG.BYOMEI"] = disease['Name']
    if ! ['9999' , '' ].include?(disease['StartDate'].to_s[0,4].strip)
      ymd = Orca::Wareki.new(disease['StartDate'])
      embed_data["STRYMD-TBL[#{idx}].STRYMDG.STRGG"] = ymd.gengoA
      embed_data["STRYMD-TBL[#{idx}].STRYMDG.STRYMD[0]"] = '%2d' % ymd.year_w
      embed_data["STRYMD-TBL[#{idx}].STRYMDG.STRYMD[1]"] = '%2d' % ymd.month
      embed_data["STRYMD-TBL[#{idx}].STRYMDG.STRYMD[2]"] = '%2d' % ymd.day
    end
    if ! ['9999' , '' ].include?(disease['EndDate'].to_s[0,4].strip)
      ymd = Orca::Wareki.new(disease['EndDate'])
      embed_data["ENDYMD-TBL[#{idx}].ENDYMDG.ENDGG"] = ymd.gengoA
      embed_data["ENDYMD-TBL[#{idx}].ENDYMDG.ENDYMD[0]"] = '%2d' % ymd.year_w
      embed_data["ENDYMD-TBL[#{idx}].ENDYMDG.ENDYMD[1]"] = '%2d' % ymd.month
      embed_data["ENDYMD-TBL[#{idx}].ENDYMDG.ENDYMD[2]"] = '%2d' % ymd.day
    end
    case disease['OutCome_Class']
    when '1'
      embed_data["TENKI-TBL[#{idx}].TENKIG.TENKI[0]"] = '○'
    when '2'
      embed_data["TENKI-TBL[#{idx}].TENKIG.TENKI[1]"] = '○'
    when '3'
      embed_data["TENKI-TBL[#{idx}].TENKIG.TENKI[2]"] = '○'
    end
  end

  def make_later_page(ary = nil, start_row = nil)
    red = File.join(File.dirname(File.expand_path(__FILE__)),RED_FILE2)
    form = Monpe::Report.new(red)
    embed_data = form.get_embed_data

    patient = @data['Patient']
    embed_data['PTNUM'] = patient['ID']
    if patient['Name'].to_s.size > 15
      embed_data['NAME2'] = patient['Name'].to_s[0,30]
    else
      embed_data['NAME'] = patient['Name'].to_s[0,15]
    end
    hospital = @data['Hospital']
    embed_data['IRYOMEI'] = hospital['Name']

    unless ary.nil?
      MIDDLE_PAGE_DISEASE_ROWS.times do |j|
        i = start_row + j
        disease = ary[i]
        next unless disease
        idx = j
        set_disease_row(embed_data,disease,idx)
      end
    end

    form.set_embed_data(embed_data)
    return form
  end
end

# 全角の指定文字を左から削除する関数
def lstrip_fullwidth(str, char)
  # 引数チェック
  unless str.is_a?(String) && char.is_a?(String) && char.length > 0
    raise ArgumentError, "str と char は文字列で、char は1文字以上必要です"
  end

  # 正規表現で先頭の指定文字を連続削除
  # Regexp.escape で正規表現メタ文字をエスケープ
  pattern = /\A#{Regexp.escape(char)}+/
  str.sub(pattern, "")
end

=begin
pdf_file = "Karte_a405hc01.pdf"

form_data = <<EOF
{
  "Forms": [
    {
      "data": {
      }
    }
  ]
}
EOF

conf = { :api_user => 'ormaster',
         :api_key => 'ormaster',
         :api_server => 'localhost',
         :api_port => 8000 }
opt = Hash.new
opt[:conf] = conf
require 'json'
form = Karte_a405hc01.new
form.export(pdf_file, JSON.parse(form_data), opt)
=end
